
%Modified Kai's simulation code to test C++ beamforming algorithm.
clear all;
output_file = 'US_Testdata1.txt';
%output_file2 = 'US_Testdata1test.txt';

soundSpeed = 1500; %speed of sound of ultrasound
no_ele = 128; %total number of elements
channelSpacing = 60/128; %distance between element to element
fs = 40e6; %sample frequency
sampleSpacing = (1/fs)*soundSpeed*1e3; %sample number vs mm
sample = 1500;

%% Simulate Data

for k = 1:5
    %location of sound source
    lateral = 0; %mm center of array is zero
    axial = 20;%mm
    position(1,k) = 0;
    position(2,k) = 10*k;
    
end
for k = 5+1:5+5
    %location of sound source
    lateral = 0; %mm center of array is zero
    axial = 20;%mm
    position(1,k) = 25;
    position(2,k) = 10*(k-5);
    
end
for k = 10+1:10+5
    %location of sound source
    lateral = 0; %mm center of array is zero
    axial = 20;%mm
    position(1,k) = -25;
    position(2,k) = 10*(k-10);
    
end

rf = zeros(sample,no_ele);
for k = 1:15
    for i = 1:no_ele
        r_lat = i*channelSpacing;
        for j = 1:sample
            r = sqrt((r_lat-(position(1,k)+(no_ele+1)/2)*channelSpacing)^2 + position(2,k)^2); %distance from sound source to array
            distance = r/sampleSpacing; %mm to sample number
            rf(j,i) = rf(j,i) + sin((j-distance)*0.05*pi)*exp(-log(2)*((j-distance)/15)^2)* (1/distance);
        end
    end
    
end

noise = max(max(rf))*randn(size(rf,1),size(rf,2));
rf_n = rf + noise;

%% Ultrasound Beamforming
times = 1;

for i = 1:no_ele*times
    rf_n2(:,i) = rf(:,ceil(i/times));
end
bfdata_US = DAS_US2(rf, no_ele, channelSpacing, soundSpeed,times);

%%
%Write out all results to given output file.
fileID = fopen(output_file,'w');
%for i = 1: size(bfdata_US,1)
%   fprintf(fileID, '%6.6f  ', bfdata_US(i,:));
%end
fprintf(fileID, '%6.20f  ', bfdata_US);
fclose('all');



%% Synthetic Aperture Beamforming (C++)

bfdata_original=DAS_SASB_DRF(bfdata_US,no_ele*times,60/128/times, soundSpeed,fs);
tic();
system('RebeamformerTest.exe');%Execute c++ rebeamforming algorithm.
bfdata = (importdata('PA_Outputdata1.txt'))';
toc();
%% Display

st = 100;
y = ([st sample]/(fs))*soundSpeed*1000;
x = [1 no_ele*times] * (60/128/times);

Bpost_DAQ = abs(hilbert(bfdata));
figure;
Bpost_DAQ = Bpost_DAQ/max(max(Bpost_DAQ));
imagesc(x,y,db(Bpost_DAQ(st:sample,:)),[-20 0]);
colormap(gray);
%axis('image')
title('Simulated PA Image using C++ Rebeamformer');
xlabel('Lateral Distance (mm)');
ylabel('Depth (mm)');

Bpost_DAQ_o = abs(hilbert(bfdata_original));
figure;
Bpost_DAQ_o = Bpost_DAQ_o/max(max(Bpost_DAQ_o));
imagesc(x,y,db(Bpost_DAQ_o(st:sample,:)),[-20 0]);
colormap(gray);
title('Simulated PA Image using Original Rebeamformer');
xlabel('Lateral Distance (mm)');
ylabel('Depth (mm)');





figure()
imagesc(x,y,(abs(hilbert(bfdata_US))));
colormap('gray');
title('Simulated US Beamformed PA Image');
xlabel('Lateral Distance (mm)');
ylabel('Depth (mm)');
%xlabel('Sampling Depth');
%ylabel('RF Amplitude');;
